
function AMZEditor(editorx) {
    //log_info("editorxy  " + editorx)
    this.editor_js = editorx //editor_js
    this.editor = $(editorx) //editor_jquery
    //log_info("editorx  " + this.editor)
    this.currentSelection = null;
    var me = this
    setChangeListener(editorx, function (event) {
          try{
//              if (event instanceof KeyboardEvent){
//               }
              me.backuprange()
              //log_info("change " + $(document).height());
              me.notify_height_changed()

          }catch(ex){
            amz_log_error("listen " + ex)
          }
    });
    
    amz_log_info("editor started")
    this.xcommand = function (obj_base64) {
        try {
            var commandDictionary = composer_decode(obj_base64);
            //unlistenOnselectionchange();                //stoppo listener
            var res = amz_editor.command(commandDictionary);
            //listenOnselectionchange();                  //rialzo listener
            //selectionchanged();
//            setTimeout(function(){
//                log_info("setTimeout " + $(document).height());
//                this.notify_height_changed()
//            }, 1000);
            return res;
        } catch (ex) {
            amz_log_error('amz_command ' + ex);
        }
    }
    
    this.command = function (commandDictionary) {
        try{
            var command = commandDictionary.command;
            //amz_log_info("command " + command)
            if (command === 'backup_range') {
                this.backuprange();
            }
            else if (command === 'insert_image') {
                this.insertImage(commandDictionary.src, commandDictionary.alt, commandDictionary.class_name, commandDictionary.width, commandDictionary.height);
            }
            else if (command === 'insert_html') {
                this.insertHTML(commandDictionary.html)
                //document.execCommand('insertHTML', false, commandDictionary.html);
            }
            else {
                amz_log_info("generic command " + command)
                document.execCommand(command, false, null);
            }
        }catch(ex){
            amz_log_error("command " + ex)
        }
        return 'ok'
    }
    
    this.insertImage = function insertImage(src, alt, class_name, width, height) {
        try{
            this.restorerange();
            var html = '<img class = "' + class_name + '" src="' + src + '" alt="' + alt + '"';
            if (width > 0) {
                html += ' width  = ' + width + 'px ';
            }
            if (height > 0) {
                html += ' height = ' + height + 'px ';
            }
            html += '/>';
            this.insertHTML(html);
        }catch(ex){
            amz_log_error("insertImage " + ex)
        }
    }
    
    this.insertHTML = function (html) {
        //amz_log_info("insertHTML " + html)
        document.execCommand('insertHTML', false, html);
    }
    
    this.backuprange = function () {
        try{
//            amz_log_info("backuprange " + window)
            var selection = window.getSelection();
//            amz_log_info("selection " + selection)
//            amz_log_info("selection rangeCount " + selection.rangeCount)
            var range
            if(selection.rangeCount == 0){
                range = document.createRange();
                range.setStart(document.body, 0);
                range.setEnd(document.body, 0);
            }else{
                range = selection.getRangeAt(0);
            }
            this.currentSelection = {
                "startContainer": range.startContainer,
                "startOffset": range.startOffset,
                "endContainer": range.endContainer,
                "endOffset": range.endOffset
            };
        }catch(ex){
            amz_log_error("backuprange " + ex)
        }
    }
    
    this.restorerange = function () {
        try{
            if (!this.currentSelection) {
                //log_info("null range")
                this.backuprange()
                //return
            }
            var selection = window.getSelection();
            selection.removeAllRanges();
            var range = document.createRange();
            //log_info("this.currentSelection.startContainer " + this.currentSelection.startContainer)
            range.setStart(this.currentSelection.startContainer, this.currentSelection.startOffset);
            range.setEnd(this.currentSelection.endContainer, this.currentSelection.endOffset);
            selection.addRange(range);
        }catch(ex){
            amz_log_error("restorerange " + ex)
        }
    }
    
    this.notify_height_changed = function() {
        try{
//            log_info("notify_height_changed " + this.editor)
//            log_info("notify_height_changed " + this.editor.height())
            send_msg({height_changed: this.editor.height()});
            try{
                send_msg({caret_position: this.getCaretYPosition()});
            }catch(ex){
                //log_error("getCaretYPosition " + ex)
            }
        }catch(ex){
            log_error("notify_height_changed " + ex)
        }
    }
    
    this.html = function() {
        return this.editor.html()
    }
    
    this.getCaretYPosition = function() {
        var sel = window.getSelection();
        // Next line is comented to prevent deselecting selection. It looks like work but if there are any issues will appear then uconmment it as well as code above.
        //sel.collapseToStart();
        var range = sel.getRangeAt(0);
        var span = document.createElement('span');// something happening here preventing selection of elements
        range.collapse(false);
        range.insertNode(span);
        
        var f =  span.getBoundingClientRect()
//        amz_log_info("y " + f.y)
//        amz_log_info("height " + f.height)
        var topPosition = f.y + f.height //  span.offsetTop;
        span.parentNode.removeChild(span);
        return topPosition;
    }
}

//var last_zoom = 1
//$(document).ready(function () {
//    amz_load()
//});
//
//function amz_load(){
//    try {
//        amz_log_info("amz_load")
//
//        var w    = $(document).width()
//        var h    = $(document).height()
//        var base = $(window).width()
//        var inner_base = base-20 //margini
//        //amz_log_info("collection ready " + base + " " + w + ":" + h);
//        //ZOOM
//        var zoom = base/w
//        if (zoom < 1) {
//            //check images
//            var modified = [];
//            //amz_log_info("zoom " + zoom)
//            $("img").each(function() {
//              try {
//                  var node = $(this)
//                  //var imgsrc = node.attr("src");
//                  //amz_log_info(width + " " + imgsrc)
//                  var width  = node.width();
//                  var offset = node.offset().left
//                  //amz_log_info(width + " " + offset)
//                  if (width > base) {
//                  var save_style = node.attr("style")
//                  if (save_style == null){save_style = ""}
//                  var cache = {obj:node, style:save_style};
//                  modified.push(cache);
//                  //amz_log_info(width + " " + imgsrc);
//
//                  //Window.devicePixelRatio
//                  var new_width = inner_base-offset;
//                  if(new_width < 0){
//                    new_width = 100
//                  }
//                  node.css("max-width", new_width+"px");
//                  node.css("display", "inline-block");
//                  node.css("height", "auto");
//
//                  //amz_log_info("css  " +   node.attr("style"));
//                  //var width2 = node.width();
//                  //amz_log_info("width2  " +   width2);
//                  }
//              }catch(ex){
//                 amz_log_err("image " + ex)
//              }
//              });
//
//            h = $(document).height()
//            w = $(document).width()
//            //amz_log_info("update " + base + " " + w + ":" + h);
//            zoom = base/w
//
//            if (zoom < 0.9) {
//                last_zoom = zoom
//                //amz_log_info("zoom2 " + zoom)
//                //amz_log_info("modified " + " " + modified)
//                //devo rollbackare le maxwidth sto per zommare tutta la pagina
//                var arrayLength = modified.length;
//                for (var i = 0; i < arrayLength; i++) {
//                    var cache = modified[i]
//                    //amz_log_info(cache.obj + " " + cache.style)
//                    cache.obj.attr("style",cache.style)
//                }
//                $('.cont').css('-webkit-transform','scale('+zoom+')');
//                $('.cont').css('-webkit-transform-origin','0 0');
//
//                h = $(document).height()
//                w = $(document).width()
//
//                //amz_log_info("end " + w + ":" + h + " final " + h * last_zoom);
//                //var f =  amz_height();
//                //amz_log_info("f " + f);
//            }
//
//        }
//    }catch(ex){
//        amz_log_err("load " + ex)
//    }
//}

function amz_height(){
    try {
        var h = $(document).height()
        //amz_log_info("amz_height " + h * last_zoom);
        return h * last_zoom
    }catch(ex){
        amz_log_err("amz_height " + ex)
    }
}


//utilities
function amz_log_err(err) {
    window.webkit.messageHandlers.log.postMessage({err: err});
}

function amz_log_info(err) {
    window.webkit.messageHandlers.log.postMessage({log: err});
}

function amz_send_msg(xvar) {
    window.webkit.messageHandlers.msg.postMessage(xvar);
}

function b64DecodeUnicode(str) {
    return decodeURIComponent(Array.prototype.map.call(atob(str), function(c) {
                                                       return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2);
                                                       }).join(''));
}

function b64EncodeUnicode(str) {
    return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function(match, p1) {
                                                return String.fromCharCode('0x' + p1);
                                                }));
}

function composer_decode(obj_base64) {
    var sDecodedParam = b64DecodeUnicode(obj_base64);
    //var sDecodedParam window.atob(obj_base64);
    return JSON.parse(sDecodedParam);
}

//listener
function setChangeListener(div,     listener) {
    div.addEventListener("blur",    listener);
    div.addEventListener("keyup",   listener);
    div.addEventListener("paste",   listener);
    div.addEventListener("copy",    listener);
    div.addEventListener("cut",     listener);
    div.addEventListener("delete",  listener);
    div.addEventListener("mouseup", listener);
//    div.addEventListener("touchstart", listener);
}

/*
 var amz_editor = new AMZEditor();
 function AMZEditor() {
 this.currentSelection = null;
 //this.blockquote_hidden  = 0;
 }
 */

/*
 //call from external
 
 AMZEditor.prototype.command = function (commandDictionary) {
 var command = commandDictionary.command;
 log_info("command " + command)
 if (command === 'backup_range') {
 this.backuprange();
 }
 else if (command === 'insert_image') {
 this.insertImage(commandDictionary.src, commandDictionary.alt, commandDictionary.width, commandDictionary.height);
 }
 else if (command === 'insert_html') {
 this.insertHTML(commandDictionary.html)
 //document.execCommand('insertHTML', false, commandDictionary.html);
 }
 else {
 log_info("generic command " + command)
 document.execCommand(command, false, null);
 }
 return 'ok'
 }
 
 //actions
 AMZEditor.prototype.insertImage = function insertImage(src, alt, class_name, width, height) {
 this.restorerange();
 var html = '<img class = "' + class_name + '" src="' + src + '" alt="' + alt + '"';
 if (width > 0) {
 html += ' width  = ' + width + 'px ';
 }
 if (height > 0) {
 html += ' height = ' + height + 'px ';
 }
 html += '/>';
 this.insertHTML(html);
 }
 
 AMZEditor.prototype.insertHTML = function (html) {
 document.execCommand('insertHTML', false, html);
 }
 
 AMZEditor.prototype.backuprange = function () {
 var selection = window.getSelection();
 var range = selection.getRangeAt(0);
 this.currentSelection = {
 "startContainer": range.startContainer,
 "startOffset": range.startOffset,
 "endContainer": range.endContainer,
 "endOffset": range.endOffset
 };
 }
 
 AMZEditor.prototype.restorerange = function () {
 var selection = window.getSelection();
 selection.removeAllRanges();
 var range = document.createRange();
 range.setStart(this.currentSelection.startContainer, this.currentSelection.startOffset);
 range.setEnd(this.currentSelection.endContainer, this.currentSelection.endOffset);
 selection.addRange(range);
 }

 function notify_height_changed(){
 send_msg({height_changed: $(editor).height()});
 }
 */
